/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.Trace;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class TaskLegacyOrder {
    private static final String TRACE_MASKT = "XTLGORDT";
    private static final String TRACE_MASKF = "XTLGORDF";
    private static final String TRACE_MASKD = "XTLGORDD";
    private static final String LEGACY_ORDER_PROPS_FILE = "data/TaskLegacyOrder.properties";
    private static final String KEY_DELIMITER = ",";
    private static final String GROUP_LEGACY_ORDER = "task.groups.order";
    private Properties legacyOrderProps;

    public TaskLegacyOrder() {
        Trace.trace(TRACE_MASKF, "<> TaskLegacyOrder constructor()");
        this.legacyOrderProps = new Properties();
        try {
            this.legacyOrderProps.load(new FileInputStream(LEGACY_ORDER_PROPS_FILE));
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "   Exception in TaskLegacyOrder constructor, exc=" + exc);
        }
    }

    public String[] sortTasks(Map properties, String parentKey) {
        Trace.trace(TRACE_MASKF, "-> TaskLegacyOrder.getTaskOrder(), parentKey is " + parentKey);
        String[] result = null;
        result = this.sortByLegacyProperties(properties, parentKey);
        Trace.trace(TRACE_MASKF, "<- TaskLegacyOrder.sortTasks()");
        return result;
    }

    public String[] sortTaskGroups(Map properties) {
        Trace.trace(TRACE_MASKF, "-> TaskLegacyOrder.sortTaskGroups()");
        String[] result = null;
        result = this.sortByLegacyProperties(properties, GROUP_LEGACY_ORDER);
        Trace.trace(TRACE_MASKF, "<- TaskLegacyOrder.sortTaskGroups()");
        return result;
    }

    public String[] sortByLegacyProperties(Map properties, String key) {
        Trace.trace(TRACE_MASKF, "-> TaskLegacyOrder.sortByLegacyProperties()");
        String[] result = null;
        String[] legacyOrder = null;
        String keys = this.legacyOrderProps.getProperty(key);
        if (keys != null) {
            legacyOrder = this.parseKeys(keys);
        }
        if (legacyOrder == null) {
            Trace.trace(TRACE_MASKF, "   'key' argument is unknown");
            result = TaskLegacyOrder.sortByName(properties);
        } else {
            int i;
            String[] shortIds = new String[legacyOrder.length];
            HashMap<String, Map> unkShortIds = null;
            Iterator iter = properties.keySet().iterator();
            while (iter.hasNext()) {
                String shortId = (String)iter.next();
                Map shortIdMap = (Map)properties.get(shortId);
                String shortIdKey = (String)shortIdMap.get("ObjectIdNameKey");
                if (shortIdKey == null) {
                    throw new IllegalArgumentException("UIObjectsConstants.OBJECT_ID_NAME_KEY_PROPERTY not in Map.  shortId is " + shortId);
                }
                boolean found = false;
                for (int i2 = 0; !found && i2 < legacyOrder.length; ++i2) {
                    if (!shortIdKey.equals(legacyOrder[i2])) continue;
                    shortIds[i2] = shortId;
                    found = true;
                }
                if (found) continue;
                if (unkShortIds == null) {
                    unkShortIds = new HashMap<String, Map>();
                }
                unkShortIds.put(shortId, shortIdMap);
            }
            int numKeys = 0;
            for (int i3 = 0; i3 < shortIds.length; ++i3) {
                if (shortIds[i3] == null) continue;
                ++numKeys;
            }
            if (unkShortIds != null) {
                numKeys += unkShortIds.size();
            }
            result = new String[numKeys];
            int next = 0;
            for (i = 0; i < shortIds.length; ++i) {
                if (shortIds[i] == null) continue;
                result[next++] = shortIds[i];
            }
            if (unkShortIds != null) {
                shortIds = TaskLegacyOrder.sortByName(unkShortIds);
                for (i = 0; i < shortIds.length; ++i) {
                    result[next++] = shortIds[i];
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- TaskLegacyOrder.sortByLegacyProperties()");
        return result;
    }

    public static String[] sortByName(Map properties) {
        Trace.trace(TRACE_MASKF, "<- TaskLegacyOrder.sortByName()");
        String[] keys = properties.keySet().toArray(new String[properties.size()]);
        for (int i = 0; i < keys.length; ++i) {
            Map map = (Map)properties.get(keys[i]);
            String name1 = (String)map.get("Name");
            if (name1 == null) {
                throw new IllegalArgumentException("NAME_PROPERTY is not in the Map argument.");
            }
            for (int j = i + 1; j < keys.length; ++j) {
                map = (Map)properties.get(keys[j]);
                String name2 = (String)map.get("Name");
                if (name2 == null) {
                    throw new IllegalArgumentException("NAME_PROPERTY is not in the Map argument.");
                }
                if (name2.compareToIgnoreCase(name1) >= 0) continue;
                String temp = keys[i];
                keys[i] = keys[j];
                keys[j] = temp;
                name1 = name2;
            }
        }
        return keys;
    }

    public String[] parseKeys(String keys) {
        Trace.trace(TRACE_MASKF, "-> TaskLegacyOrder.parseKeys( " + keys + " )");
        StringTokenizer st = new StringTokenizer(keys, KEY_DELIMITER);
        String[] keysArray = new String[st.countTokens()];
        Trace.trace(TRACE_MASKF, "   number of keys = " + st.countTokens());
        int index = 0;
        while (st.hasMoreTokens()) {
            keysArray[index] = st.nextToken();
            ++index;
        }
        Trace.trace(TRACE_MASKF, "<- TaskLegacyOrder.parseKeys()");
        return keysArray;
    }

    public static void main(String[] args) {
        TaskLegacyOrder orderer = new TaskLegacyOrder();
        HashMap props = new HashMap();
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("ObjectIdNameKey", "base.task.hwmsg");
        props.put("1", map1);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("ObjectIdNameKey", "z.task.resetn");
        props.put("2", map2);
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("ObjectIdNameKey", "base.task.grouping");
        props.put("3", map3);
        HashMap<String, String> map4 = new HashMap<String, String>();
        map4.put("ObjectIdNameKey", "base.task.activate");
        props.put("4", map4);
        HashMap<String, String> map5 = new HashMap<String, String>();
        map5.put("ObjectIdNameKey", "z.task.sad");
        props.put("5", map5);
        String[] tasks = orderer.sortTasks(props, "base.taskgroup.daily");
        for (int i = 0; i < tasks.length; ++i) {
            System.out.println("tasks[ " + i + " ] = " + tasks[i]);
        }
        props.clear();
        map1 = new HashMap();
        map1.put("ObjectIdNameKey", "z.taskgroup.chgman");
        props.put("1", map1);
        map2 = new HashMap();
        map2.put("ObjectIdNameKey", "base.taskgroup.service");
        props.put("2", map2);
        map3 = new HashMap();
        map3.put("ObjectIdNameKey", "base.taskgroup.daily");
        props.put("3", map3);
        map4 = new HashMap();
        map4.put("ObjectIdNameKey", "base.taskgroup.consact");
        props.put("4", map4);
        map5 = new HashMap();
        map5.put("ObjectIdNameKey", "base.taskgroup.objdef");
        props.put("5", map5);
        HashMap<String, String> map6 = new HashMap<String, String>();
        map6.put("ObjectIdNameKey", "A_unknown");
        map6.put("Name", "A_unknown");
        props.put("6", map6);
        HashMap<String, String> map7 = new HashMap<String, String>();
        map7.put("ObjectIdNameKey", "C_unknown");
        map7.put("Name", "C_unknown");
        props.put("7", map7);
        HashMap<String, String> map8 = new HashMap<String, String>();
        map8.put("ObjectIdNameKey", "B_unknown");
        map8.put("Name", "B_unknown");
        props.put("8", map8);
        String[] groups = orderer.sortTaskGroups(props);
        for (int i = 0; i < groups.length; ++i) {
            System.out.println("groups[ " + i + " ] = " + groups[i]);
        }
    }
}

